/*
   kml2the.c:
     A small utility to convert between (some) kedit .kml macro files and
     THE .the macro files.

   How it is used:

     kml2the < yourinputfile.kml

   How it works:
     It looks for definitions of the form
     definition:
     and creates a file with that name where the contents of the
     definition are dumped.

   About comments:
     Comments starting with:
     *   are ignored in the header, otherwise dumped to the 
         corresponding THE macro.
     *-  are ignored always
     *:  in the header are always dumped to all THE macros

   Author: Agustn Martn Domingo agmartin@aq.upm.es

           I know this is quite poor C, and that things are highly 
           improvable. As is written this program does what I need, and
           so, I will hardly dedicate more time to it. However, feel free
           to add useful modifications. If that is the case, please let me
           know about that modifications.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   For a copy of the GNU General Public License look for a file
   named COPYING at the main THE distribution or in any gnu mirror.
   If a copy of the GNU Public license is not available, write to 
   the Free Software Foundation,
   675 Mass Ave, Cambridge, MA 02139, USA.

*/

#include<stdio.h>
#include<string.h>

int header=1, first_char, i, in_macro=0, split=1;
int length;
char string[256], outputname[40], GPLstring[2000];
char *auxstring=NULL;
FILE *fpout = stdout;

int main(void)
{

   if(split==0) fpout=fopen("latexmac.the","w");

   strcpy(GPLstring,"");

   while(gets(string))
   {
      first_char = string[0];
      switch (first_char)
      {
         case '*': if(header==1 && string[1]==':')
                   {
                      auxstring = string + 2;
                      if (string[2] == ' ') auxstring++;
                      strcat(GPLstring," * ");
                      strcat(GPLstring,auxstring);
                      strcat(GPLstring,"\n");
                      auxstring=NULL;
                   } else if(header==1 && string[1]!=':'){
                   } else if(header==0 && string[1]=='-'){
                   } else {
                      fprintf(fpout,"/%s */\n",string);
                   }
                   break;
         case ':': if(header == 1){
                      printf("%s\n",GPLstring);

                      if(split==0)
                      {
                         Write_GPL();
                         fprintf(fpout,"input__comm = arg(1)\n\n");
                         fprintf(fpout,"Select\n\n");
                      }

                   }
                   header = 0;

                   if(in_macro==1)
                   {
                      if(split==1) fclose(fpout);
                      else fprintf(fpout,"   End\n\n");
                   }

                   in_macro=1;
                   strcpy(outputname,"");
                   sscanf(string,":%s",outputname);

                   if(split==1)
                   {
                      strcat(outputname,".the");
                      fpout=fopen(outputname,"w");
                      printf("Writing macro file %s\n",outputname);
                      Write_GPL();
                   } else {
                      fprintf(fpout,"   When input__comm == '%s' Then Do\n",
                                                                outputname);
                   }

                   break;

         default:  fprintf(fpout,"%s\n",string);
                   break;
      }
   }

   if(split==0)
   {
      fprintf(fpout,"   End\n\n");
      fprintf(fpout,"End\n");
      fprintf(fpout,"Exit\n");
      fclose(fpout);
   }

   return 0;
}/* End of Main */

int Write_GPL(void){
  fprintf(fpout,""
  "/*--------------------------------------------------------------*/\n");
  fprintf(fpout,"/* %s -- \n",outputname);
  if(split==1) {
    fprintf(fpout," * Part of the macro package\n");
  } else {
    fprintf(fpout," * This file contains the full macro package\n");
  }
  if(GPLstring!="") fprintf(fpout,"%s",GPLstring);
  fprintf(fpout," *\n");
   fprintf(fpout," * This macros are free software; you can redistribute them and/or modify\n");
   fprintf(fpout," * them under the terms of the GNU General Public License as published by\n");
   fprintf(fpout," * the Free Software Foundation; either version 2, or (at your option)   \n");
   fprintf(fpout," * any later version.                                                    \n");
   fprintf(fpout," * This macros are distributed in the hope that they will be useful,     \n");
   fprintf(fpout," * but WITHOUT ANY WARRANTY; without even the implied warranty of        \n");
   fprintf(fpout," * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         \n");
   fprintf(fpout," * GNU General Public License for more details.                          \n");
   fprintf(fpout," *                                                                       \n");
   fprintf(fpout," * For a copy of the GNU General Public License look for a file          \n");
   fprintf(fpout," * named COPYING at the main THE distribution or at any GNU mirror.      \n");
   fprintf(fpout," * If a copy of the GNU Public license is not available, write to        \n");
   fprintf(fpout," * the Free Software Foundation,                                         \n");
   fprintf(fpout," * 675 Mass Ave, Cambridge, MA 02139, USA.                               \n");
  fprintf(fpout,"*/\n");
  fprintf(fpout,"/*--------------------------------------------------------------*/\n");
  fprintf(fpout,"\n");
return 0;
}/* End of Write_GPL */
